#include <winsock2.h>
#include <stdio.h>
#include <iostream>
#include <string>
#include <fstream>

using namespace std;

DWORD client_accept_threadId, client_instance_threadId;
HANDLE client_accept_handle_Thread;

DWORD WINAPI client_instance(void *);
DWORD WINAPI client_accept(void *);
string recv(SOCKET, int *); //perdengimas
string order_pizza(string, string);
string get_name(int, string);
float get_price(int, string);
string get_from_file_pizzas();
//void write_in_file(TPizzaList[], string, int);

typedef struct SThreadData {
    SOCKET sock;
	string p_sar;
};

typedef struct TPizzaList {
    int pizza_nr;
    string pizza_name;
    float pizza_price;
};

int main(int argc, char *argv[]){

    char * listening_address = "127.0.0.1";//argv[1];
    int listening_port = 657; //atoi(argv[2]);
    
    // Inicializuojame WinSock biblioteka    
    WSADATA wsaData;
    int iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
    if (iResult != NO_ERROR) {
        printf("Serveri paleisti nepavyko\nKlaidos kodas: %d\n", iResult);
        return 1;
    }
    
    // Sukuriame laukianti lizda
    SOCKET listen_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (listen_socket == INVALID_SOCKET){
        printf("Serveri paleisti nepavyko\nKlaidos kodas: %ld\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }
    
    // Aprasome laukiancio lizdo parametrus
    SOCKADDR_IN listen_socket_param;
    listen_socket_param.sin_family = AF_INET;
    listen_socket_param.sin_port = htons(listening_port);
    listen_socket_param.sin_addr.s_addr = inet_addr(listening_address);

    // Inicializuojame ir atidarome laukianti lizda
    iResult = bind(listen_socket, (SOCKADDR*)&listen_socket_param, sizeof(listen_socket_param));
    if (iResult == SOCKET_ERROR){
        closesocket(listen_socket);
        printf("Serveri paleisti nepavyko\nKlaidos kodas: %ld\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }
    iResult = listen(listen_socket, 2);
    if(iResult == SOCKET_ERROR){
        closesocket(listen_socket);
        printf("Serveri paleisti nepavyko\nKlaidos kodas: %ld\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }
	

	SThreadData Duom;
	Duom.sock = listen_socket;
	string picu_sarasas = get_from_file_pizzas();
	Duom.p_sar = picu_sarasas;
	
    client_accept_handle_Thread = CreateThread(NULL,0,client_accept, (void *) &Duom, 0, & client_accept_threadId);

    printf("Noredami iseiti, iveskite q\n");
    string _code;
    do {
		cin >> _code;
	} while (_code != "q");
	
    TerminateThread(client_accept_handle_Thread, 0);
    closesocket(listen_socket);
    
    WSACleanup();
    return 0;
}
//==============================================================================
 
DWORD WINAPI client_instance(void *param){
	SThreadData *Duom = (SThreadData*) param;
	SOCKET sock = Duom -> sock;
	string picu_sarasas = Duom -> p_sar;
	
    string send_buffer, received_data, message = "OK\n";	
    cout<<"Prisijunge naujas klientas"<<endl;
    int nErr = 0;
    send(sock, message.c_str(), message.length() + 1, 0);
    do {
    	received_data = recv(sock, &nErr);
    	if (received_data.substr(0,5) == "LIST "){
            cout<<"Klientas paprase picu saraso"<<endl;
            picu_sarasas = get_from_file_pizzas();
            send(sock, picu_sarasas.c_str(), picu_sarasas.length() + 1, 0);
		} if (received_data.substr(0,5) == "ORDER"){	
            cout<<"Klientas uzsisake pica"<<endl;
			send_buffer = order_pizza(received_data, picu_sarasas);   
			send_buffer += "\n";
            send(sock, send_buffer.c_str(),send_buffer.length() + 1, 0);    
		} if (received_data.substr(0,5) == "EXIT "){
            send_buffer = "***Geros Dienos***\n";
            send(sock, send_buffer.c_str(), send_buffer.length() + 1, 0);
        }
	} while (nErr == 0);
	closesocket(sock);
	cout<<"Klientas atsijunge"<<endl;
    return 0;
}

//------------------------------------------------------------------------------

DWORD WINAPI client_accept(void *param){
	SThreadData *Duom = (SThreadData*) param;
	SOCKET listensock = Duom -> sock;
	
	 // Laukiame prisijungimu
	for(;;) {
        Duom -> sock = accept(listensock, NULL, NULL);
        if (Duom -> sock != INVALID_SOCKET)
        	CreateThread(NULL,0,client_instance, (void *) param, 0, & client_instance_threadId);
    } 
}

//------------------------------------------------------------------------------

string recv(SOCKET client_socket, int *isErr){
	char recv_buf; 
    string recv_data; 
    int recv_count;
	do {
		recv_count = recv(client_socket, &recv_buf,1,0);
		if (recv_count != 1){*isErr = -1; break;}
		if ((recv_buf != '\n')&&(recv_buf != '\r')){
		   recv_data += recv_buf;
        }
        
	} while ((recv_buf != '\r')&&(recv_buf != '\n'));
 	return recv_data;

}

//------------------------------------------------------------------------------

string order_pizza(string str, string p_sar){
	int addr_pos = str.find("ADDR:");
	string pizzas = str.substr(6, addr_pos - 5);
	string address = str.substr(addr_pos + 5,str.length() - addr_pos - 5);
	FILE *pFile;
    pFile = fopen("uzsakymas.txt", "a" ); 
    fprintf(pFile, "%s%s%s%s"  ,"=============================\n", "Pristatyti adresu : ", address.c_str(), "\nPicas :\n");
	int pz_c = 0;
	for (int i = 0; i <= pizzas.length(); i++){
        if (pizzas[i] == ';') pz_c++;
    }
    TPizzaList * pPizzaList[pz_c]; for(int i = 0; i < pz_c; i++) pPizzaList[i] = new TPizzaList;
    string buf;
    for (int i = 0, j = 0; i <= pizzas.length(); i++){
        if (pizzas[i] == ';'){
           pPizzaList[j] -> pizza_nr = atoi(buf.c_str());
           pPizzaList[j] -> pizza_name = get_name(pPizzaList[j] -> pizza_nr, p_sar);
           pPizzaList[j] -> pizza_price = get_price(pPizzaList[j] -> pizza_nr, p_sar);
           fprintf(pFile, "%s\t\n" , pPizzaList[j]->pizza_name.c_str());
           buf.clear();
           j++;
        } else {
           buf += pizzas[i];
        }
    }
    fclose(pFile);
    float kaina = 0;
    for (int i = 1; i <= pz_c; i++){
        kaina += pPizzaList[i] -> pizza_price;
    }
    
    string ret_val = "Jusu uzsakymas priimtas! Bus pristatytas adresu " + address + " gatve per 45 min. Skanaus!";
    return ret_val;
}

//------------------------------------------------------------------------------

string get_name(int _num, string _buf){
   for (int i = 0, j = 0; i <= _buf.length(); i++){
       if (_buf[i] == '\n'){
          j++;
       } else if (j == ((_num - 1) * 2)){
             _buf = _buf.substr(i,_buf.length() - i - 1);
             return _buf.substr(0,_buf.find('\n'));
       }
   }
}

//------------------------------------------------------------------------------

float get_price(int _num, string _buf){
         
	for (int i = 0, j = 0; i <= _buf.length(); i++){
		if (j == (2*_num -1)){
			float price;   
			_buf = _buf.substr(i,_buf.length() - i - 1);
			_buf = _buf.substr(0,_buf.find('\n'));
			sscanf(_buf.c_str(), "%f", &price);
			return price;
		} else if (_buf[i] == '\n') j++;
	}
}
//------------------------------------------------------------------------------

string get_from_file_pizzas(){
    FILE *pFile;  
    string picu_sarasas;
    char *fbuf = new char;
    pFile = fopen("avail_pizza.txt","r");
    do {
       	fread(fbuf, 1, 1, pFile); 
	    picu_sarasas += *fbuf;
    } while (!feof(pFile));
	fclose(pFile);
	delete fbuf;
    return picu_sarasas;
}

//------------------------------------------------------------------------------
